<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\notificationController;
use App\Models\CompetitionEventModel;
use App\Models\CompetitionModel;
use App\Models\CompetitionUserModel;
use App\Models\LiveHD;
use App\Models\UserFavoriteTeamModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class HaddafController extends Controller
{
    public static function devices()
    {
        $headers = [
            'Content-Type: application/json'
        ];

        $fields = [
            'token' => "00000000-11b9-c329-ffff-ffff99d603a9",
        ];
        #Send Reponse To FireBase Server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'http://api.haddafapp.com/api/v2/devices');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        //dd(curl_exec($ch));
        $response = json_decode(curl_exec($ch), true);

        curl_close($ch);
        return $response['auth_token'];
    }

    public static function get_competition_list_today()
    {
        // $auth_token = HaddafController::devices();
        $auth_token = "OF60YPI7Bxw06lCa6TkeNA";
        $headers = [
            'Content-Type: application/json',
            "auth-token:$auth_token",
        ];

        #Send Reponse To FireBase Server
        $time_stamp = strtotime(date('Y-m-d H:i:s'));

        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, "http://api.haddafapp.com/api/v2/sports/soccer/competitions_with_matches?date=$time_stamp");
        curl_setopt($ch2, CURLOPT_POST, false);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        //dd(curl_exec($ch));
        //  var_dump(curl_exec($ch2));
        $response = json_decode(curl_exec($ch2), true);
        CompetitionModel::where('date', '<', date('Y-m-d'))->delete();
        CompetitionEventModel::where('created_at', '<', date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . "-1 day")))->delete();
        if ($response && sizeof($response) > 0) {
            foreach ($response as $re) {

                if (sizeof($re['matches']) > 0) {

                    foreach ($re['matches'] as $match) {
                        if (!CompetitionModel::where('competition_id', $match['id'])->get()->first()) {
                            $competition = new CompetitionModel();
                            $competition->competition_id = $match['id'];
                            $competition->time = $match['time'];
                            $competition->minute = $match['minute'];
                            $competition->minute_extra = $match['minute_extra'];
                            $competition->status = $match['status'];
                            $competition->date_time = date('Y-m-d H:i:s', $match['time']);
                            $competition->date = date('Y-m-d', $match['time']);
                            if(isset($match['team_a']['name']))
                            {$competition->team_a = $match['team_a']['name'];

                            }else
                            {
                                $competition->team_a = "";
                            }

                            if(isset($match['team_b']['name']))
                            { $competition->team_b = $match['team_b']['name'];

                            }else
                            {
                                $competition->team_b ="";
                            }


                            $competition->match_period = $match['match_period'];
                            $competition->save();
                            //  "match_period": "HT",
                            //  "match_period": "2H",,

                            if(isset($match['team_b']['id'] ) && isset($match['team_a']['id'])) {

                                HaddafController::extract_favorite_team_comp($match['team_a']['id'],$match['team_b']['id'],$match['id']);
                            }

                        } else {
                            if(isset($match['team_b']['id'] ) && isset($match['team_a']['id']))
                            {

                                HaddafController::extract_favorite_team_comp($match['team_a']['id'],$match['team_b']['id'],$match['id']);
                            }
                            $competitio_ = CompetitionModel::where('competition_id', $match['id'])->get()->first();

                            /*  بداية المباراة */
                            if ($competitio_->status == "fixture" && $match['status'] == "playing" && $competitio_->if_sent_reminder_when_match_start == 0) {

                                HomeController::send_notification_to_all_user($match['id'], "reminder_when_match_start");
                                $competitio_->if_sent_reminder_when_match_start = 1;
                                $competitio_->save();
                            }

                            /*   انتهاء الشوط الاول */
                            if ($competitio_->match_period == "1H" && $match['match_period'] == "HT" && $competitio_->if_sent_reminder_end_first_half == 0) {

                                HomeController::send_notification_to_all_user($match['id'], "reminder_end_first_half");
                                $competitio_->if_sent_reminder_end_first_half = 1;
                                $competitio_->save();

                            }

                            /*  انتهاء المباراة */

                            if ($competitio_->status == "playing" && $match['status'] == "played" && $competitio_->if_sent_reminder_end_competition == 0) {

                                HomeController::send_notification_to_all_user($match['id'], "reminder_end_competition");
                                $competitio_->if_sent_reminder_end_competition = 1;
                                $competitio_->save();
                            }


                            $competitio_->status = $match['status'];
                            $competitio_->date_time = date('Y-m-d H:i:s', $match['time']);
                            $competitio_->minute = $match['minute'];
                            $competitio_->minute_extra = $match['minute_extra'];
                            $competitio_->match_period = $match['match_period'];
                            $competitio_->date = date('Y-m-d', $match['time']);
                            $competitio_->save();

                        }

                        $diff = $match['time'] - time();
                        $days = floor($diff / (60 * 60 * 24));
                        $minute = round(($diff - $days * 60 * 60 * 24) / (60));
                        $competitio_ = CompetitionModel::where('competition_id', $match['id'])->get()->first();


                        /*قبل بداية المباراة بساعة واحدة  */
                        if ($competitio_->if_sended_reminder_befor_hour == 0 && $minute <= 60 && $competitio_->if_sent_reminder_before_hour == 0) {

                            HomeController::send_notification_to_all_user($match['id'], "reminder_before_hour");
                            $competitio_->if_sent_reminder_before_hour = 1;
                            $competitio_->save();
                        }

                        /*  إذا كانت اللعبة جارية الآن  يتم فحص البطاقاات الحمراء  والاهداق */
                        if ($competitio_->status == "playing") {

                            HaddafController::competition_details($competitio_->competition_id);
                        }

                    }
                }
            }
        }

        curl_close($ch2);
    }



    public static function live_HDVIDEO()
    {
        $headers_live = [
            'Content-Type: application/json'
        ];

        $ch_live = curl_init();
        curl_setopt($ch_live, CURLOPT_URL, "http://mtc.mosalslat-app.com/match/api5.php?cat_id=1");
        curl_setopt($ch_live, CURLOPT_HTTPHEADER, $headers_live);
        curl_setopt($ch_live, CURLOPT_HEADER, 0);
        curl_setopt($ch_live, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch_live, CURLOPT_SSL_VERIFYPEER, false);

        $response = json_decode(curl_exec($ch_live), true);

        $live=$response['HDvideo'];

        if(sizeof($live)>0)
        {
            foreach ($live as $item_live)
            {
//var_dump($item_live['video_duration']);
//die();
                if(date('Y-m-d',strtotime($item_live['video_duration'])) == date('Y-m-d') && $item_live["cat_id"]==1)
                {
                    $live_saved= LiveHD::where('id_live',$item_live["id"])->get();
                    if(!sizeof($live_saved)>0)
                    {
                        $live_= new LiveHD();
                        $live_->id_live=$item_live["id"];
                        $live_->save();

                        $user = DB::table('user')->get();

                        foreach ($user as $item) {
                            $notification = new notificationController(

                                array(
                                    'body' => "",
                                    'title' =>  $item_live["video_title"]  . " يوجد بث مباشر لمباراة  ",
                                    'icon' => 'myicon',
                                    'sound' => 'mySound',
                                    'notification_data' => $item_live,
                                ),
                                $item->firebase_token,
                                ""

                            );
                            $notification->send();
                        }
                    }


                }
            }
        }
        curl_close($ch_live);
    }




    public static function live_HDVIDEO_TEST()
    {
        $headers_live = [
            'Content-Type: application/json'
        ];

        $ch_live = curl_init();
        curl_setopt($ch_live, CURLOPT_URL, "");
        curl_setopt($ch_live, CURLOPT_HTTPHEADER, $headers_live);
        curl_setopt($ch_live, CURLOPT_HEADER, 0);
        curl_setopt($ch_live, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch_live, CURLOPT_SSL_VERIFYPEER, false);

        $response = json_decode(curl_exec($ch_live), true);

        $live=$response['HDvideo'];

        if(sizeof($live)>0)
        {
            foreach ($live as $item_live)
            {
//var_dump($item_live['video_duration']);
//die();

                        $user = DB::table('user')->get();

                        foreach ($user as $item) {
                            $notification = new notificationController(

                                array(
                                    'body' => "",
                                    'title' =>  $item_live["video_title"]  . " يوجد بث مباشر لمباراة  ",
                                    'icon' => 'myicon',
                                    'sound' => 'mySound',
                                    'notification_data' => $item_live,
                                ),
                                $item->firebase_token,
                                ""

                            );
                            $notification->send();


                }
            }
        }
        curl_close($ch_live);
    }
    public static function extract_favorite_team_comp($team_1, $team_2, $comp)
    {
        foreach (UserFavoriteTeamModel::all() as $item) {
            if ($item->team_id == $team_1 || $item->team_id == $team_2) {

                if (!sizeof(CompetitionUserModel::where('user_id', $item->user_id)->where('competition_id', $comp)->get()) > 0) {
                    $comp_new = new CompetitionUserModel();
                    $comp_new->user_id = $item->user_id;
                    $comp_new->competition_id = $comp;
                    $comp_new->save();
                }
            }
        }

    }

    public static function competition_details($compentition_id)
    {

        // $auth_token = HaddafController::devices();
        $auth_token = "OF60YPI7Bxw06lCa6TkeNA";
        $headers = [
            'Content-Type: application/json',
            "auth-token:$auth_token",
        ];


        $ch3 = curl_init();
        curl_setopt($ch3, CURLOPT_URL, "http://api.haddafapp.com/api/v2/sports/soccer/matches/$compentition_id");
        curl_setopt($ch3, CURLOPT_POST, false);
        curl_setopt($ch3, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch3, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch3, CURLOPT_SSL_VERIFYPEER, false);
        //dd(curl_exec($ch));
        //  var_dump(curl_exec($ch2));
        $response = json_decode(curl_exec($ch3), true);

        if ($response) {
            if (sizeof($response['events']) > 0) {

                foreach ($response['events'] as $item) {
                    /* البطاقة الحمرة  او  غول جديد */
                    if ($item['code'] == "RC" || $item['code'] == "G") {
                        if (!CompetitionEventModel::where('event_id', $item['id'])->get()->first()) {
                            $event = new CompetitionEventModel();
                            $event->event_id = $item['id'];
                            $event->code = $item['code'];
                            $event->team = $item['team'];
                            $event->player = $item['player'];
                            $event->minute = $item['minute'];
                            $event->save();
                            HomeController::send_notification_to_all_user_competition_details($compentition_id, $event->event_id, $item['code'],$response['match']);
                        }

                    }

                }
            }
        }

        curl_close($ch3);
    }
}
