<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\notificationController;
use App\Models\CompetitionEventModel;
use App\Models\CompetitionModel;
use App\Models\CompetitionUserModel;
use App\Models\UserFavoriteTeamModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{

    public function register(Request $request)
    {
        $firebase_token = $request->input('firebase_token');
        $hash = $request->input('hash');

        $user___ = User::where('hash', $hash)->get();
        if (sizeof($user___) > 0) {
            $user___ = $user___[0];
            $user___->firebase_token = $firebase_token;
            $user___->save();
            return response()->json(['status' => true, 'user_id' => $user___]);
        } else {

            if ($firebase_token && strlen($firebase_token) > 0 && $hash && strlen($hash) > 0) {

                if (!sizeof(User::where('firebase_token', $firebase_token)->get()) > 0) {

                    $user = new User();
                    $user->firebase_token = $firebase_token;
                    $user->hash = $hash;
                    $user->save();
                    return response()->json(['status' => true, 'user_id' => $user]);
                } else {
                    return response()->json(['status' => false, 'user_id' => null]);
                }
            } else {
                return response()->json(['status' => false, 'user_id' => null]);

            }

        }

    }

    public function edit_reminders(Request $request)
    {
        $user_id = $request->input('user_id');
        $reminder_before_hour = $request->input('reminder_before_hour');
        $reminder_when_match_start = $request->input('reminder_when_match_start');
        $reminder_end_first_half = $request->input('reminder_end_first_half');
        $reminder_enter_goal = $request->input('reminder_enter_goal');
        $reminder_red_card = $request->input('reminder_red_card');
        $reminder_end_competition = $request->input('reminder_end_competition');
        $reminder_brodcast_live = $request->input('reminder_brodcast_live');

        $user = User::find($user_id);
        $user->reminder_before_hour = $reminder_before_hour;
        $user->reminder_when_match_start = $reminder_when_match_start;
        $user->reminder_end_first_half = $reminder_end_first_half;
        $user->reminder_enter_goal = $reminder_enter_goal;
        $user->reminder_red_card = $reminder_red_card;
        $user->reminder_end_competition = $reminder_end_competition;
        $user->reminder_brodcast_live = $reminder_brodcast_live;

        if ($user->save()) {

            return response()->json(['status' => true, 'user' => $user]);
        } else {
            return response()->json(['status' => false, 'user' => null]);

        }
    }

    public function user_competition_list(Request $request)
    {
        $user_id = $request->input('user_id');

        return response()->json(['status' => true, 'list' => CompetitionUserModel::where('user_id', $user_id)->get()]);

    }

    public function turn_on_off_reminder(Request $request)
    {

        $user_id = $request->input('user_id');
        $competition_id = $request->input('competition_id');

        $competition_user = CompetitionUserModel::where('user_id', $user_id)->where('competition_id', $competition_id)->get();
        if (sizeof($competition_user) > 0) {
            $competition_user = $competition_user[0];
            $competition_user->delete();
            return response()->json(['status' => true, 'user_id' => $user_id, 'is_deleted' => 1]);
        } else {

            $competition_user = new CompetitionUserModel();
            $competition_user->user_id = $user_id;
            $competition_user->competition_id = $competition_id;
            if ($competition_user->save()) {

                return response()->json(['status' => true, 'user_id' => $user_id, 'is_deleted' => 0]);
            } else {
                return response()->json(['status' => false, 'user_id' => null, 'is_deleted' => null]);

            }
        }

    }

    public function favorite_team(Request $request)
    {
        $teams = $request->input('teams');
        $user_id = $request->input('user_id');
        UserFavoriteTeamModel::where('user_id', $user_id)->delete();
        if ($teams) {
            foreach ($teams as $item) {
                $com = UserFavoriteTeamModel::where('user_id', $user_id)->where('team_id', $item)->get();
                if (!sizeof($com) > 0) {
                    $com_ = new UserFavoriteTeamModel();
                    $com_->user_id = $user_id;
                    $com_->team_id = $item;
                    $com_->save();
                }
            }
        }

        return response()->json(['status' => true]);
    }

    public static function send_notification_to_all_user($competition_id, $type_reminder)
    {
        $competition = CompetitionModel::where('competition_id', $competition_id)->get()->first();

        $user = DB::table('competition_user')->join('user', 'user.id', '=', 'competition_user.user_id')->where('competition_id', $competition_id)->get();


        $title = "";
        $body = "";
        foreach ($user as $item) {

            $send = 0;
            if ($type_reminder == "reminder_before_hour") {

                $title = "هناك مباراة ستبدأ بعد ساعة ";
                $body = "ستبدأ مباراة " . " بعد ساعة من الآن " . " $competition->team_b " . " ضد " . " $competition->team_a ";
                if ($item->reminder_before_hour == 1) $send = 1;
            }

            if ($type_reminder == "reminder_end_first_half") {

                $title = "نهاية الشوط الاول ";
                $body = " انتهى الشوط الأول من مباراة " . "" . " $competition->team_b " . " ضد " . " $competition->team_a ";
                if ($item->reminder_end_first_half == 1) $send = 1;
            }

            if ($type_reminder == "reminder_end_competition") {

                $title = "نهاية الوقت الفعلي للمباراة  ";
                $body = " انتهت مباراة  " . "" . " $competition->team_b " . " ضد " . " $competition->team_a ";
                if ($item->reminder_end_competition == 1) $send = 1;
            }

            if ($type_reminder == "reminder_when_match_start") {

                $title = "بداية مباراة جديدة ";
                $body = " بدأت الآن  مباراة  " . "" . " $competition->team_b " . " ضد " . " $competition->team_a ";
                if ($item->reminder_when_match_start == 1) $send = 1;
            }


            if ($send) {

                $notification = new notificationController(

                    array(
                        'body' => $title,
                        'title' => $body,
                        'icon' => 'myicon',
                        'sound' => 'mySound',
                        'competition_id' => $competition_id,
                    ),
                    $item->firebase_token,
                    ""

                );
                $notification->send();

            }

        }

    }

    public static function send_notification_to_all_user_competition_details($competition_id, $event_id, $type_reminder,$match=null)
    {
        $competition = CompetitionModel::where('competition_id', $competition_id)->get()->first();
        $event = CompetitionEventModel::where('event_id', $event_id)->get()->first();

        $user = DB::table('competition_user')->join('user', 'user.id', '=', 'competition_user.user_id')->where('competition_id', $competition_id)->get();


        $title = "";
        $body = "";
        foreach ($user as $item) {

            $send = 0;
            if ($type_reminder == "RC") {

                $title = "بطاثة حمراء جديدة ";
                $body = " حصل اللاعب " . "" . " $event->player " . " على بطاقة حمراء   " . " في مباراة  " . " " . $competition->team_b . " ضد  " . " $competition->team_a ";
                if ($item->reminder_red_card == 1) $send = 1;
            }

            if ($type_reminder == "G") {

                $title = "تسجيل هدف جديد  ";

                $team_a_goal=$match["team_a"]["fs"];
                $team_b_goal=$match["team_b"]["fs"];
                $body =  $team_a_goal ." - ". $team_b_goal ." ". $competition->team_b ." ضد " . $competition->team_a .PHP_EOL  ;
//                $body.= " احرز اللاعب " . "" . " $event->player " . " هدف  " . " في مباراة  " . " " . $competition->team_b . " ضد  " . " $competition->team_a ";

                $body.= " احرز اللاعب " . "" . " $event->player " . " هدف  ";
                if ($item->reminder_enter_goal == 1) $send = 1;
            }


            if ($send) {

                $notification = new notificationController(

                    array(
                        'body' => $title,
                        'title' => $body,
                        'icon' => 'myicon',
                        'sound' => 'mySound',
                        'competition_id' => $competition_id,
                    ),
                    $item->firebase_token,
                    ""

                );
                $notification->send();

            }

        }
    }

    public function send_not(Request $request)
    {
        $com_id = $request->input('competition_id');
        $body = $request->input('body');
        $user = DB::table('user')->get();

        foreach ($user as $item) {
            $notification = new notificationController(

                array(
                    'body' => $body,
                    'title' => "بث مباشر",
                    'icon' => 'myicon',
                    'sound' => 'mySound',
                    'competition_id' => $com_id,
                ),
                   $item->firebase_token,
                    ""

            );
           return json_decode($notification->send());
        }
    }
     public function send_not_live (Request $request)
    {
        $com_id = $request->input('competition_id');
        $body = $request->input('body');

        $user = DB::table('user')->get();

        foreach ($user as $item) {
            $notification = new notificationController(

                array(
                    'body' => $body,
                    'title' => "بث مباشر",
                    'icon' => 'myicon',
                    'sound' => 'mySound',
                    'competition_id' => $com_id,
                ),
                   $item->firebase_token,
                    ""

            );
           return json_decode($notification->send());
        }
    }
}
